<?php 
include 'db.php';

session_start();
if(isset($_SESSION['login'])){

?>
<!-- Status message -->
<div class="statusMsg"></div>

<!-- File upload form -->
<div class="col-lg-12">
    <form id="fupForm" enctype="multipart/form-data">
        <div class="form-group">
            <label for="name">Name:</label>
            <input type="text" class="form-control" name="name" placeholder="Enter name" required />
        </div>
        <div class="form-group">
        <label for="email">Email:</label>
            <input type="email" class="form-control" name="email" placeholder="Enter email" required />
        </div>
        <div class="form-group">
        <label for="password">Password:</label>
            <input type="password" class="form-control" name="password" placeholder="Enter password" required />
        </div>
        <div class="form-group">
            <label for="fileToUpload">File:</label>
            <input type="file" class="form-control" id="fileToUpload" name="fileToUpload" required />
        </div>
        
        <input type="submit" name="submit" class="btn btn-primary submitBtn" value="SUBMIT"/>
    </form>
</div>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script type="text/javascript">
	$(document).ready(function(e){
    // Submit form data via Ajax
    $("#fupForm").on('submit', function(e){
        e.preventDefault();
        $.ajax({
            type: 'POST',
            url: 'upload.php',
            data: new FormData(this),
            dataType: 'json',
            contentType: false,
            cache: false,
            processData:false,
            beforeSend: function(){
                $('.submitBtn').attr("disabled","disabled");
                $('#fupForm').css("opacity",".5");
            },
            success: function(response){
                $('.statusMsg').html('');
                if(response.status == 1){
                    $('#fupForm')[0].reset();
                    $('.statusMsg').html('<p class="alert alert-success">'+response.message+'</p>');
                }else{
                    $('.statusMsg').html('<p class="alert alert-danger">'+response.message+'</p>');
                }
                $('#fupForm').css("opacity","");
                $(".submitBtn").removeAttr("disabled");
            }
        });
    });
});
</script>
<?php }
?>