<?php
/**
 * Template part for displaying posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package visarzo
 */

	$blog_single_social      = visarzo_get_options( 'blog_single_social' );
	$single_post_thumb_class = 'no-single-post-thumb';
if ( has_post_thumbnail() ) :
	$single_post_thumb_class = '';
	endif;
	$the_title_content    = get_the_title();
	$the_title_class_have = 'have-title-post';
if ( $the_title_content != '' ) :
	$the_title_class_have = '';
	endif;
?>
	<div class="blog-details-content <?php echo esc_attr( $single_post_thumb_class . ' ' . $the_title_class_have ); ?>">
		<div class="news-block-one">
			<div class="inner-box">
				<?php if ( has_post_thumbnail() ) : ?>
					<figure class="image-box">
						<?php visarzo_post_thumbnail(); ?>
					</figure>
				<?php endif; ?>
				<div class="lower-content">
					<div class="post-date"><h5><?php visarzo_posted_on(); ?></h5></div>
					<?php
					if ( is_singular() ) :
						the_title( '<h2 class="entry-title">', '</h2>' );
						else :
							the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
						endif;
						?>
					<ul class="post-info clearfix">
						<li><?php visarzo_posted_by(); ?></li>
						<li><?php visarzo_category_list(); ?></li>
						<li><?php visarzo_comments_count(); ?></li>
					</ul>
					<div class="text">
						<?php the_content(); ?>
					</div>
				</div>
			</div>
		</div>
		<?php
			wp_link_pages(
				array(
					'before' => '<div class="page-links">',
					'after'  => '</div>',
				)
			);
			?>
		<?php
			$blog_single_social_class = 'off-share-option';
		if ( $blog_single_social ) {
			$blog_single_social_class = '';
		}
		?>
		<div class="post-share-option clearfix <?php echo esc_attr( $blog_single_social_class ); ?>">
			<ul class="tags pull-left clearfix">
				<li><?php esc_html_e( 'Category:', 'visarzo' ); ?></li>
				<li><?php visarzo_category_list(); ?></li>
			</ul>
			<?php if ( $blog_single_social == '1' ) : ?>
				<ul class="social-links pull-right clearfix">
					<li><?php esc_html_e( 'Share:', 'visarzo' ); ?></li>
					<?php
						do_action( 'visarzo_blog_social_ready' );
					?>
				</ul>
			<?php endif; ?>
		</div>
		<?php
			// If comments are open or we have at least one comment, load up the comment template.
		if ( comments_open() || get_comments_number() ) :
			comments_template();
			endif;
		?>
	</div>