<?php
	$post_thumb_class = 'no-post-thumb';
if ( has_post_thumbnail() ) :
	$post_thumb_class = '';
	endif;
	$is_sticky_class = '';
if ( is_sticky() ) :
	$is_sticky_class = 'sticky_post_class';
	endif;
	$blog_grid_date = visarzo_get_options( 'blog_grid_date' );
?>
<div class="col-lg-4 col-md-6 col-sm-12 news-block <?php echo esc_attr( $post_thumb_class . ' ' . $is_sticky_class ); ?>">
	<div class="news-block-one wow fadeInUp animated animated" data-wow-delay="00ms" data-wow-duration="1500ms">
		<?php
		if ( is_sticky() ) {
			echo '<div class="sticky_post_icon " title="' . esc_attr__( 'Sticky Post', 'visarzo' ) . '"><i class="fas fa-map-pin"></i></div>';
		}
		?>
		<div class="inner-box">
			<?php if ( has_post_thumbnail() ) : ?>
				<figure class="image-box">
					<?php the_post_thumbnail( 'visarzo-blog-grid' ); ?>
				</figure>
			<?php endif; ?>
			<div class="lower-content">
				<?php if ( $blog_grid_date == '2' ) : ?>
					<div class="post-date"><h2><?php echo get_the_date( 'j' ); ?></h2><span><?php echo get_the_date( 'M' ); ?></span></div>
				<?php else : ?>
					<div class="post-date post-date-two">
						<?php visarzo_posted_on(); ?>
					</div>
				<?php endif; ?>
				<?php
				if ( is_singular() ) :
					the_title( '<h3 class="entry-title">', '</h3>' );
					else :
						the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );
					endif;
					?>
				<ul class="post-info clearfix">
					<li><?php visarzo_posted_by(); ?></li>
					<li><?php visarzo_category_list(); ?></li>
				</ul>
				<div class="link"><a href="<?php echo esc_url( get_permalink() ); ?>"><?php esc_html_e( 'Read More', 'visarzo' ); ?><i class="flaticon-send"></i></a></div>
			</div>
		</div>
	</div>
</div>

