<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package visarzo
 */
get_header();
	if (is_active_sidebar('sidebar-1')) :
		$blog_post_list_class = 'col-lg-8';
	else :
		$blog_post_list_class = 'col-lg-12';
	endif;

	$blog_single_base_css   = visarzo_get_options( 'blog_single_base_css' );
	$blog_single_base_class = 'base-blog-single';
	if($blog_single_base_css == 1 ) :
		$blog_single_base_class = '';
	endif;
?>
	<div class="sidebar-page-container blog-details <?php echo esc_attr($blog_single_base_class); ?>">
		<div class="auto-container">
			<div class="row clearfix">
				<div class="<?php echo esc_attr($blog_post_list_class); ?> col-md-12 col-sm-12 content-side">
					<?php
						if (have_posts()) :
							
							while (have_posts()) :
								the_post();
								get_template_part('template-parts/single/content', get_post_format());
							endwhile;
						endif;
					?>
				</div>
				<?php if (is_active_sidebar('sidebar-1')) { ?>
					<div class="col-lg-4 col-md-12 col-sm-12 sidebar-side">
						<div class="sidebar blog-sidebar">
							<?php get_sidebar(); ?>
						</div>
					</div>
				<?php } ?>
			</div>
		</div>
	</div>
<?php
get_footer();