<?php
/**
 * ReduxFramework Barebones Sample Config File
 * For full documentation, please visit: http://docs.reduxframework.com/
 */
if ( ! class_exists( 'Redux' ) ) {
	return;
}

// This is your option name where all the Redux data is stored.
$opt_prefix = 'visarzo_';
$opt_name   = 'visarzo_options';
/**
 * ---> SET ARGUMENTS
 * All the possible arguments for Redux.
 * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
 * */
$theme = wp_get_theme(); // For use with some settings. Not necessary.

$args = array(
	// TYPICAL -> Change these values as you need/desire
	'opt_name'             => $opt_name,
	// This is where your data is stored in the database and also becomes your global variable name.
	'display_name'         => $theme->get( 'Name' ),
	// Name that appears at the top of your panel
	'display_version'      => $theme->get( 'Version' ),
	// Version that appears at the top of your panel
	'menu_type'            => 'menu',
	// Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
	'allow_sub_menu'       => true,
	// Show the sections below the admin menu item or not
	'menu_title'           => esc_html__( 'Visarzo Options', 'visarzo' ),
	'page_title'           => esc_html__( 'Visarzo Options', 'visarzo' ),
	// You will need to generate a Google API key to use this feature.
	// Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
	'google_api_key'       => '',
	// Set it you want google fonts to update weekly. A google_api_key value is required.
	'google_update_weekly' => false,
	// Must be defined to add google fonts to the typography module
	'async_typography'     => true,
	// Use a asynchronous font on the front end or font string
	// 'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
	'admin_bar'            => true,
	// Show the panel pages on the admin bar
	'admin_bar_icon'       => 'dashicons-portfolio',
	// Choose an icon for the admin bar menu
	'admin_bar_priority'   => 50,
	// Choose an priority for the admin bar menu
	'global_variable'      => '',
	// Set a different name for your global variable other than the opt_name
	'dev_mode'             => true,
	// Show the time the page took to load, etc
	'update_notice'        => true,
	// If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
	'customizer'           => true,
	// Enable basic customizer support
	// 'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
	// 'disable_save_warn' => true,                    // Disable the save warning when a user changes a field
	// OPTIONAL -> Give you extra features
	'page_priority'        => null,
	// Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
	'page_parent'          => 'themes.php',
	// For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
	'page_permissions'     => 'manage_options',
	// Permissions needed to access the options panel.
	'menu_icon'            => '',
	// Specify a custom URL to an icon
	'last_tab'             => '',
	// Force your panel to always open to a specific tab (by id)
	'page_icon'            => 'icon-themes',
	// Icon displayed in the admin panel next to your menu_title
	'page_slug'            => '_options',
	// Page slug used to denote the panel
	'save_defaults'        => true,
	// On load save the defaults to DB before user clicks save or not
	'default_show'         => false,
	// If true, shows the default value next to each field that is not the default value.
	'default_mark'         => '',
	// What to print by the field's title if the value shown is default. Suggested: *
	'show_import_export'   => true,
	// Shows the Import/Export panel when not used as a field.
	// CAREFUL -> These options are for advanced use only
	'transient_time'       => 60 * MINUTE_IN_SECONDS,
	'output'               => true,
	// Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
	'output_tag'           => true,
	// Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
	// 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.
	// FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
	'database'             => '',
	// possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
	'use_cdn'              => true,
	// If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.
	// 'compiler'             => true,
);
Redux::setArgs( $opt_name, $args );
Redux::setSection(
	$opt_name,
	array(
		'title'  => esc_html__( 'Base theme option', 'visarzo' ),
		'id'     => 'base_theme_option',
		'desc'   => esc_html__( 'Chnage Base theme option here', 'visarzo' ),
		'icon'   => 'el el-home',
		'fields' => array(
			array(
				'id'      => $opt_prefix . 'preloader_on_off',
				'type'    => 'switch',
				'title'   => esc_html__( 'Preloader on off switch', 'visarzo' ),
				'default' => false,
				'on'      => esc_html__( 'Enable', 'visarzo' ),
				'off'     => esc_html__( 'Disable', 'visarzo' ),
			),
			array(
				'id'      => $opt_prefix . 'back_to_top_on_off',
				'type'    => 'switch',
				'title'   => esc_html__( 'Back To Top on off switch', 'visarzo' ),
				'default' => false,
				'on'      => esc_html__( 'Enable', 'visarzo' ),
				'off'     => esc_html__( 'Disable', 'visarzo' ),
			),
			array(
				'id'      => $opt_prefix . 'footer_base_css',
				'type'    => 'switch',
				'title'   => esc_html__( 'Footer base css', 'visarzo' ),
				'default' => false,
				'on'      => esc_html__( 'Enable', 'visarzo' ),
				'off'     => esc_html__( 'Disable', 'visarzo' ),
			),
			array(
				'id'      => $opt_prefix . 'blog_single_base_css',
				'type'    => 'switch',
				'title'   => esc_html__( 'Blog single base css', 'visarzo' ),
				'default' => false,
				'on'      => esc_html__( 'Enable', 'visarzo' ),
				'off'     => esc_html__( 'Disable', 'visarzo' ),
			),
			array(
				'id'      => $opt_prefix . 'blog_list_base_css',
				'type'    => 'switch',
				'title'   => esc_html__( 'Blog list base css', 'visarzo' ),
				'default' => false,
				'on'      => esc_html__( 'Enable', 'visarzo' ),
				'off'     => esc_html__( 'Disable', 'visarzo' ),
			),
			array(
				'id'      => $opt_prefix . 'color_option',
				'type'    => 'switch',
				'title'   => esc_html__( 'color on off switch', 'visarzo' ),
				'default' => false,
				'on'      => esc_html__( 'Enable', 'visarzo' ),
				'off'     => esc_html__( 'Disable', 'visarzo' ),
			),
			array(
				'id'      => $opt_prefix . 'theme_base_css',
				'type'    => 'switch',
				'title'   => esc_html__( 'theme base css', 'visarzo' ),
				'default' => false,
				'on'      => esc_html__( 'Enable', 'visarzo' ),
				'off'     => esc_html__( 'Disable', 'visarzo' ),
			),
			array(
				'id'      => $opt_prefix . 'theme_box_mode',
				'type'    => 'switch',
				'title'   => esc_html__( 'theme box mode', 'visarzo' ),
				'default' => false,
				'on'      => esc_html__( 'Enable', 'visarzo' ),
				'off'     => esc_html__( 'Disable', 'visarzo' ),
			),
			array(
				'id'      => $opt_prefix . 'typography_custom_on_off',
				'type'    => 'switch',
				'title'   => esc_html__( 'Color', 'visarzo' ),
				'default' => false,
				'on'      => esc_html__( 'Enable', 'visarzo' ),
				'off'     => esc_html__( 'Disable', 'visarzo' ),
			),
		),
	)
);
Redux::setSection(
	$opt_name,
	array(
		'title'  => esc_html__( 'Header theme option', 'visarzo' ),
		'id'     => 'header_theme_option',
		'desc'   => esc_html__( 'Chnage Header theme option here', 'visarzo' ),
		'icon'   => 'el el-home',
		'fields' => array(
			array(
				'id'      => $opt_prefix . 'header_base_css',
				'type'    => 'switch',
				'title'   => esc_html__( 'Header base css', 'visarzo' ),
				'default' => false,
				'on'      => esc_html__( 'Enable', 'visarzo' ),
				'off'     => esc_html__( 'Disable', 'visarzo' ),
			),
			array(
				'id'      => $opt_prefix . 'header_menu_style',
				'type'    => 'select',
				'title'   => esc_html__( 'Header menu style', 'visarzo' ),
				'options' => array(
					'1' => esc_html__( 'One', 'visarzo' ),
					'2' => esc_html__( 'Two', 'visarzo' ),
					'3' => esc_html__( 'Elementor Header', 'visarzo' ),
				),
			),
			array(
				'required' => array( $opt_prefix . 'header_menu_style', '=', array( '3' ) ),
				'id'       => $opt_prefix . 'header_widget_elementor',
				'type'     => 'select',
				'multi'    => true,
				'title'    => esc_html__( 'Header builder widget', 'visarzo' ),
				'options'  => visarzo_elementor_library(),
			),
			array(
				'required' => array( $opt_prefix . 'header_menu_style', '=', array( '1', '2' ) ),
				'id'       => $opt_prefix . 'header_top_bar_appointment_text',
				'type'     => 'text',
				'title'    => esc_html__( 'Button text', 'visarzo' ),
			),
			array(
				'required' => array( $opt_prefix . 'header_menu_style', '=', array( '1', '2' ) ),
				'id'       => $opt_prefix . 'header_top_bar_appointment_url',
				'type'     => 'text',
				'title'    => esc_html__( 'Button link', 'visarzo' ),
			),
			array(
				'required' => array( $opt_prefix . 'header_menu_style', '=', array( '2' ) ),
				'id'       => $opt_prefix . 'header_menu_call_action_text',
				'type'     => 'text',
				'title'    => esc_html__( 'Mega Action Text', 'visarzo' ),
			),
			array(
				'required' => array( $opt_prefix . 'header_menu_style', '=', array( '2' ) ),
				'id'       => $opt_prefix . 'header_menu_call_action_link',
				'type'     => 'text',
				'title'    => esc_html__( 'Mega Action link', 'visarzo' ),
			),
			array(
				'required' => array( $opt_prefix . 'header_menu_style', '=', array( '2' ) ),
				'id'       => $opt_prefix . 'header_menu_call_action_num',
				'type'     => 'text',
				'title'    => esc_html__( 'Mega Action Number', 'visarzo' ),
			),
			array(
				'required' => array( $opt_prefix . 'header_menu_style', '=', array( '2' ) ),
				'id'       => $opt_prefix . 'header_menu_search',
				'type'     => 'switch',
				'title'    => esc_html__( 'Search button', 'visarzo' ),
				'default'  => false,
				'on'       => esc_html__( 'Enable', 'visarzo' ),
				'off'      => esc_html__( 'Disable', 'visarzo' ),
			),
		),
	)
);
Redux::setSection(
	$opt_name,
	array(
		'title'      => esc_html__( 'Header Top Bar', 'visarzo' ),
		'id'         => 'header_menu_option',
		'subsection' => true,
		'icon'       => 'el el-home',
		'fields'     => array(
			array(
				'id'      => $opt_prefix . 'header_top_bar_style',
				'type'    => 'select',
				'title'   => esc_html__( 'Header top bar style', 'visarzo' ),
				'options' => array(
					'1' => esc_html__( 'One', 'visarzo' ),
					'2' => esc_html__( 'Two', 'visarzo' ),
				),
			),
			array(
				'required' => array( $opt_prefix . 'header_top_bar_style', '=', array( '1' ) ),
				'id'       => $opt_prefix . 'header_top_bar_phone',
				'type'     => 'text',
				'title'    => esc_html__( 'phone', 'visarzo' ),
			),
			array(
				'required' => array( $opt_prefix . 'header_top_bar_style', '=', array( '1', '2' ) ),
				'id'       => $opt_prefix . 'header_top_bar_email',
				'type'     => 'text',
				'title'    => esc_html__( 'email', 'visarzo' ),
			),
			array(
				'required' => array( $opt_prefix . 'header_top_bar_style', '=', '2' ),
				'id'       => $opt_prefix . 'header_time_info',
				'type'     => 'text',
				'title'    => esc_html__( 'Time', 'visarzo' ),
			),
			array(
				'required' => array( $opt_prefix . 'header_top_bar_style', '=', '2' ),
				'id'       => $opt_prefix . 'header_addorss_info',
				'type'     => 'text',
				'title'    => esc_html__( 'Address', 'visarzo' ),
			),
			array(
				'required' => array( $opt_prefix . 'header_top_bar_style', '=', array( '1' ) ),
				'id'       => $opt_prefix . 'header_top_bar_search',
				'type'     => 'switch',
				'title'    => esc_html__( 'Search button', 'visarzo' ),
				'default'  => false,
				'on'       => esc_html__( 'Enable', 'visarzo' ),
				'off'      => esc_html__( 'Disable', 'visarzo' ),
			),
			array(
				'required' => array( $opt_prefix . 'header_top_bar_style', '=', array( '1', '2' ) ),
				'id'       => $opt_prefix . 'header_top_bar_social',
				'type'     => 'ace_editor',
				'title'    => esc_html__( 'Header social icon', 'visarzo' ),
				'subtitle' => esc_html__( 'copy free icon code, visit: ', 'visarzo' ) . '<a href="https://fontawesome.com/icons?d=gallery" target="_blank">fontawesome</a>',
			),
		),
	)
);
Redux::setSection(
	$opt_name,
	array(
		'title'      => esc_html__( 'sticky header Menu', 'visarzo' ),
		'id'         => 'sticky_header_menu_option',
		'subsection' => true,
		'desc'       => esc_html__( 'Chnage Header Menu option here', 'visarzo' ),
		'icon'       => 'el el-home',
		'fields'     => array(
			array(
				'id'      => $opt_prefix . 'sticky_header_on',
				'type'    => 'switch',
				'title'   => esc_html__( 'sticky header on off switch', 'visarzo' ),
				'default' => false,
				'on'      => esc_html__( 'Enable', 'visarzo' ),
				'off'     => esc_html__( 'Disable', 'visarzo' ),
			),
			array(
				'required' => array( $opt_prefix . 'sticky_header_on', '=', '1' ),
				'id'       => $opt_prefix . 'sticky_header_logo',
				'type'     => 'media',
				'url'      => true,
				'title'    => esc_html__( 'sticky header logo', 'visarzo' ),
			),
		),
	)
);
Redux::setSection(
	$opt_name,
	array(
		'title'      => esc_html__( 'Mobile Menu', 'visarzo' ),
		'id'         => 'mobile_menu_option',
		'subsection' => true,
		'desc'       => esc_html__( 'Chnage mobile Menu option here', 'visarzo' ),
		'icon'       => 'el el-home',
		'fields'     => array(
			array(
				'id'    => $opt_prefix . 'mobile_menu_logo',
				'type'  => 'media',
				'url'   => true,
				'title' => esc_html__( 'mobile logo', 'visarzo' ),
			),
			array(
				'id'    => $opt_prefix . 'mobile_menu_contatc',
				'type'  => 'ace_editor',
				'title' => esc_html__( 'mobile contact info', 'visarzo' ),
			),
			array(
				'id'    => $opt_prefix . 'mobile_menu_social',
				'type'  => 'ace_editor',
				'title' => esc_html__( 'mobile contact social', 'visarzo' ),
			),
		),
	)
);

Redux::setSection(
	$opt_name,
	array(
		'title'            => esc_html__( 'Typography', 'visarzo' ),
		'id'               => 'fonts_settings',
		'desc'             => esc_html__( 'Typography', 'visarzo' ),
		'customizer_width' => '400px',
		'icon'             => 'el el-font',
		'fields'           => array(
			array(
				'id'       => 'enable_typography',
				'type'     => 'switch',
				'title'    => esc_html__( 'Typography', 'visarzo' ),
				'subtitle' => esc_html__( 'Enable or Disable Typography', 'visarzo' ),
				'default'  => false,
				'off'      => esc_html__( 'Disable', 'visarzo' ),
				'on'       => esc_html__( 'Enable', 'visarzo' ),
			),
			array(
				'required'   => array( 'enable_typography', '=', '1' ),
				'id'         => $opt_prefix . '-body_typography',
				'type'       => 'typography',
				'title'      => esc_html__( 'Body Typography', 'visarzo' ),
				'subtitle'   => esc_html__( 'Select body font family, size, line height, color and weight.', 'visarzo' ),
				'text-align' => false,
				'subsets'    => false,
				'output'     => array( 'body' ),

			),
			array(
				'required'   => array( 'enable_typography', '=', '1' ),
				'id'         => $opt_prefix . '-heading-1-typography',
				'type'       => 'typography',
				'title'      => esc_html__( 'H1 Font', 'visarzo' ),
				'subtitle'   => esc_html__( 'Select heading font family and weight.', 'visarzo' ),
				'google'     => true,
				'text-align' => false,
				'output'     => array( 'h1' ),
			),
			array(
				'required'   => array( 'enable_typography', '=', '1' ),
				'id'         => $opt_prefix . '-heading-2-typography',
				'type'       => 'typography',
				'title'      => esc_html__( 'H2 Font', 'visarzo' ),
				'subtitle'   => esc_html__( 'Select heading font family and weight.', 'visarzo' ),
				'google'     => true,
				'text-align' => false,
				'output'     => array( 'h2' ),

			),
			array(
				'required'   => array( 'enable_typography', '=', '1' ),
				'id'         => $opt_prefix . '-heading-3-typography',
				'type'       => 'typography',
				'title'      => esc_html__( 'H3 Font', 'visarzo' ),
				'subtitle'   => esc_html__( 'Select heading font family and weight.', 'visarzo' ),
				'google'     => true,
				'text-align' => false,
				'output'     => array( 'h3' ),
			),
			array(
				'required'   => array( 'enable_typography', '=', '1' ),
				'id'         => $opt_prefix . '-heading-4-typography',
				'type'       => 'typography',
				'title'      => esc_html__( 'H4 Font', 'visarzo' ),
				'subtitle'   => esc_html__( 'Select heading font family and weight.', 'visarzo' ),
				'google'     => true,
				'text-align' => false,
				'output'     => array( 'h4' ),
			),
			array(
				'required'   => array( 'enable_typography', '=', '1' ),
				'id'         => $opt_prefix . '-heading-5-typography',
				'type'       => 'typography',
				'title'      => esc_html__( 'H5 Font', 'visarzo' ),
				'subtitle'   => esc_html__( 'Select heading font family and weight.', 'visarzo' ),
				'google'     => true,
				'text-align' => false,
				'output'     => array( 'h5' ),
			),
			array(
				'required'   => array( 'enable_typography', '=', '1' ),
				'id'         => $opt_prefix . '-heading-6-typography',
				'type'       => 'typography',
				'title'      => esc_html__( 'H6 Font', 'visarzo' ),
				'subtitle'   => esc_html__( 'Select heading font family and weight.', 'visarzo' ),
				'google'     => true,
				'text-align' => false,
				'output'     => array( 'h6' ),
			),

		),
	)
);
Redux::setSection(
	$opt_name,
	array(
		'title'  => esc_html__( 'Breadcrumb area', 'visarzo' ),
		'id'     => 'breadcrumb_area',
		'icon'   => 'el el-home',
		'fields' => array(
			array(
				'id'      => $opt_prefix . 'blog_breadcrumb_switch',
				'type'    => 'switch',
				'title'   => esc_html__( 'Blog breadcrumb on off switch', 'visarzo' ),
				'default' => false,
				'on'      => esc_html__( 'Enable', 'visarzo' ),
				'off'     => esc_html__( 'Disable', 'visarzo' ),
			),
			array(
				'required' => array( $opt_prefix . 'blog_breadcrumb_switch', '=', '1' ),
				'id'       => $opt_prefix . 'blog_breadcrumb_bg',
				'type'     => 'background',
				'url'      => true,
				'title'    => esc_html__( 'Blog breadcrumb background', 'visarzo' ),
				'output'   => array(
					'background' => '.blog-breadcrumb',
				),
			),
			array(
				'required' => array( $opt_prefix . 'blog_breadcrumb_switch', '=', '1' ),
				'id'       => $opt_prefix . 'blog_breadcrumb_content',
				'type'     => 'text',
				'title'    => esc_html__( 'Blog breadcrumb title', 'visarzo' ),
				'default'  => esc_html__( 'Blog Page', 'visarzo' ),
			),
			array(
				'id'      => $opt_prefix . 'blog_single_breadcrumb_switch',
				'type'    => 'switch',
				'title'   => esc_html__( 'Blog Single breadcrumb on off switch', 'visarzo' ),
				'default' => false,
				'on'      => esc_html__( 'Enable', 'visarzo' ),
				'off'     => esc_html__( 'Disable', 'visarzo' ),
			),
			array(
				'required' => array( $opt_prefix . 'blog_single_breadcrumb_switch', '=', '1' ),
				'id'       => $opt_prefix . 'blog_single_breadcrumb_bg',
				'type'     => 'background',
				'url'      => true,
				'title'    => esc_html__( 'Blog Single breadcrumb background', 'visarzo' ),
				'output'   => array(
					'background' => '.blog-single-breadcrumb',
				),
			),
			array(
				'required' => array( $opt_prefix . 'blog_single_breadcrumb_switch', '=', '1' ),
				'id'       => $opt_prefix . 'blog_single_breadcrumb_content',
				'type'     => 'text',
				'title'    => esc_html__( 'Blog single breadcrumb title', 'visarzo' ),
				'default'  => esc_html__( 'Blog Details', 'visarzo' ),
			),
			array(
				'id'     => $opt_prefix . 'coachings_single_breadcrumb_bg',
				'type'   => 'background',
				'url'    => true,
				'title'  => esc_html__( 'coachings Single breadcrumb background', 'visarzo' ),
				'output' => array(
					'background' => '.coachings-single-breadcrumb',
				),
			),
			array(
				'id'     => $opt_prefix . 'service_single_breadcrumb_bg',
				'type'   => 'background',
				'url'    => true,
				'title'  => esc_html__( 'service Single breadcrumb background', 'visarzo' ),
				'output' => array(
					'background' => '.service-single-breadcrumb',
				),
			),
			array(
				'id'    => $opt_prefix . 'service_details_title',
				'type'  => 'textarea',
				'title' => esc_html__( 'Service Details Title', 'visarzo' ),
			),
			array(
				'id'    => $opt_prefix . 'coaching_details_title',
				'type'  => 'textarea',
				'title' => esc_html__( 'Coaching Details Title', 'visarzo' ),
			),
		),
	)
);
Redux::setSection(
	$opt_name,
	array(
		'title'  => esc_html__( 'Blog option', 'visarzo' ),
		'id'     => 'blog_option_panale',
		'desc'   => esc_html__( 'Change blog option', 'visarzo' ),
		'icon'   => 'el el-home',
		'fields' => array(
			array(
				'id'      => $opt_prefix . 'blog_style',
				'type'    => 'select',
				'title'   => esc_html__( 'Blog style', 'visarzo' ),
				'options' => array(
					'1' => esc_html__( 'One', 'visarzo' ),
					'2' => esc_html__( 'Two', 'visarzo' ),
				),
			),
			array(
				'id'      => $opt_prefix . 'blog_single_social',
				'type'    => 'switch',
				'title'   => esc_html__( 'social share', 'visarzo' ),
				'default' => false,
				'on'      => esc_html__( 'Enable', 'visarzo' ),
				'off'     => esc_html__( 'Disable', 'visarzo' ),
			),
			array(
				'id'      => $opt_prefix . 'blog_grid_date',
				'type'    => 'select',
				'title'   => esc_html__( 'Blog Grid date style', 'visarzo' ),
				'options' => array(
					'1' => esc_html__( 'One', 'visarzo' ),
					'2' => esc_html__( 'Two', 'visarzo' ),
				),
			),
		),
	)
);
Redux::setSection(
	$opt_name,
	array(
		'title'  => esc_html__( 'Elementor widget for Footer', 'visarzo' ),
		'id'     => 'footer_widget_elementor_lib',
		'icon'   => 'el el-home',
		'fields' => array(
			array(
				'id'      => $opt_prefix . 'footer_left_widget_elementor',
				'type'    => 'select',
				'multi'   => true,
				'title'   => esc_html__( 'Footer widget', 'visarzo' ),
				'options' => visarzo_elementor_library(),
			),
			array(
				'id'      => $opt_prefix . 'footer_top_widget_elementor',
				'type'    => 'select',
				'multi'   => true,
				'title'   => esc_html__( 'Footer top widget', 'visarzo' ),
				'options' => visarzo_elementor_library(),
			),
		),
	)
);
Redux::setSection(
	$opt_name,
	array(
		'title'  => esc_html__( 'Footer option', 'visarzo' ),
		'id'     => 'visarzo_footer_area',
		'desc'   => esc_html__( 'Chnage footer option here', 'visarzo' ),
		'icon'   => 'el el-home',
		'fields' => array(
			array(
				'id'    => $opt_prefix . 'footer_copyright',
				'type'  => 'text',
				'title' => esc_html__( 'Copyright text', 'visarzo' ),
			),
			array(
				'id'    => $opt_prefix . 'footer_link',
				'type'  => 'ace_editor',
				'title' => esc_html__( 'Footer link', 'visarzo' ),
			),
		),
	)
);
Redux::setSection(
	$opt_name,
	array(
		'title'  => esc_html__( 'Color option', 'visarzo' ),
		'id'     => 'visarzo_color_area',
		'desc'   => esc_html__( 'Chnage Color option here', 'visarzo' ),
		'icon'   => 'el el-home',
		'fields' => array(
			array(
				'id'          => $opt_prefix . 'main_color',
				'type'        => 'color',
				'title'       => esc_html__( 'Primary Color', 'visarzo' ),
				'subtitle'    => esc_html__( 'Pick a color for the theme (default: #f8952c).', 'visarzo' ),
				'validate'    => 'color',
				'transparent' => false,
			),

		),
	)
);
Redux::setSection(
	$opt_name,
	array(
		'title'            => esc_html__( 'Extra Settings', 'visarzo' ),
		'id'               => 'extra_settings',
		'desc'             => esc_html__( 'These are really basic fields!', 'visarzo' ),
		'customizer_width' => '400px',
		'icon'             => 'el el-share',
		'fields'           => array(
			array(
				'id'       => $opt_prefix . 'slug_postype',
				'type'     => 'text',
				'title'    => esc_html__( 'Custom Post Type Visarzo Service', 'visarzo' ),
				'subtitle' => esc_html__( 'Visarzo Slug Name', 'visarzo' ),
				'desc'     => 'You might have to flush your permalinks after you performed this action Settings=> Permalink Settings',
			),
			array(
				'id'       => $opt_prefix . 'slug_postype_coaching',
				'type'     => 'text',
				'title'    => esc_html__( 'Custom Post Type Visarzo Coaching', 'visarzo' ),
				'subtitle' => esc_html__( 'Visarzo Slug Name', 'visarzo' ),
				'desc'     => 'You might have to flush your permalinks after you performed this action Settings=> Permalink Settings',
			),
		),
	)
);
