<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package visarzo
 */
	$footer_copyright = visarzo_get_options( 'footer_copyright' );
	$footer_link      = visarzo_get_options( 'footer_link' );
	$footer_base_css  = visarzo_get_options( 'footer_base_css' );

	$footer_base_css_class = 'base-footer';
if ( $footer_base_css == 1 ) :
	$footer_base_css_class = '';
endif;
?>
<?php get_template_part( 'components/footer/footer-top' ); ?>
<footer class="main-footer bg-color-2 <?php echo esc_attr( $footer_base_css_class ); ?>">
	<div class="auto-container">
		<div class="footer-bottom clearfix">
			<div class="copyright pull-left">
				<p>
					<?php
					if ( $footer_copyright != '' ) :
						echo wp_kses( $footer_copyright, 'code_contxt' );
					else :
						echo esc_html__( '&copy; 2020 VISARZO. Immigration &amp; Visa Firm. All rights reserved.', 'visarzo' );
					endif;
					?>
				</p>
			</div>
			<?php if ( $footer_link ) : ?>
				<ul class="footer-nav pull-right clearfix"> 
					<?php echo sprintf( __( '%s', 'visarzo' ), $footer_link ); ?>
				</ul>
			<?php endif; ?>
		</div>
	</div>
</footer>
<?php do_action( 'visarzo_back_to_top_ready' ); ?>
<?php wp_footer(); ?>
</body>
</html>
